/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.cocosjs;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.anythink.cocosjs.utils.JSPluginUtil;
import com.anythink.cocosjs.utils.MsgTools;
import com.anythink.core.api.ATSDK;
import com.anythink.core.api.NetTrafficeCallback;
import java.util.HashMap;
import java.util.Iterator;
import org.cocos2dx.lib.Cocos2dxActivity;
import org.cocos2dx.lib.Cocos2dxJavascriptJavaBridge;
import org.json.JSONObject;

public class ATJSBridge {
    private static Activity mActivity = JSPluginUtil.getActivity();

    public static void initSDK(String appId, String appkey) {
        MsgTools.pirntMsg("initSDK:" + appId + ":" + appkey);
        ATSDK.init((Context)mActivity.getApplicationContext(), (String)appId, (String)appkey);
    }

    public static void initCustomMap(String customMap) {
        MsgTools.pirntMsg("initCustomMap:" + customMap);
        if (!TextUtils.isEmpty((CharSequence)customMap)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            try {
                JSONObject jsonObject = new JSONObject(customMap);
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    map.put(key, jsonObject.opt(key));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ATSDK.initCustomMap(map);
        }
    }

    public static void setPlacementCustomMap(String placementId, String customMap) {
        MsgTools.pirntMsg("setPlacementCustomMap:" + placementId + ":" + customMap);
        if (!TextUtils.isEmpty((CharSequence)customMap)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            try {
                JSONObject jsonObject = new JSONObject(customMap);
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    map.put(key, jsonObject.opt(key));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ATSDK.initPlacementCustomMap((String)placementId, map);
        }
    }

    public static void setGDPRLevel(int level) {
        MsgTools.pirntMsg("setGDPRLevel:" + level);
        ATSDK.setGDPRUploadDataLevel((Context)mActivity.getApplicationContext(), (int)level);
    }

    public static int getGDPRLevel() {
        int gdprDataLevel = ATSDK.getGDPRDataLevel((Context)mActivity.getApplicationContext());
        MsgTools.pirntMsg("getGDPRLevel:" + gdprDataLevel);
        return gdprDataLevel;
    }

    public static void getUserLocation(final String callbackName) {
        ATSDK.checkIsEuTraffic((Context)mActivity.getApplicationContext(), (NetTrafficeCallback)new NetTrafficeCallback(){

            public void onResultCallback(boolean b) {
                MsgTools.pirntMsg("onResultCallback:" + b);
                final int result = b ? 1 : 2;
                MsgTools.pirntMsg("Call JS:" + callbackName + "(" + result + ");");
                if (!TextUtils.isEmpty((CharSequence)callbackName)) {
                    ((Cocos2dxActivity)mActivity).runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(callbackName + "(" + result + ");"));
                        }
                    });
                }
            }

            public void onErrorCallback(String s) {
                MsgTools.pirntMsg("onErrorCallback:" + s);
                if (!TextUtils.isEmpty((CharSequence)callbackName)) {
                    ((Cocos2dxActivity)mActivity).runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(callbackName + "(" + 0 + ");"));
                        }
                    });
                }
            }
        });
        MsgTools.pirntMsg("getUserLocation");
    }

    public static void showGDPRAuth() {
        MsgTools.pirntMsg("showGDPRAuth:");
        mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ATSDK.showGdprAuth((Context)mActivity.getApplicationContext());
            }
        });
    }

    public static void setLogDebug(boolean isDebug) {
        MsgTools.setLogDebug(isDebug);
        MsgTools.pirntMsg("setLogDebug:" + isDebug);
        ATSDK.setNetworkLogDebug((boolean)isDebug);
    }

    public static void deniedUploadDeviceInfo(String arrayString) {
        MsgTools.pirntMsg("deniedUploadDeviceInfo " + arrayString);
        if (!TextUtils.isEmpty((CharSequence)arrayString)) {
            String[] split = arrayString.split(",");
            ATSDK.deniedUploadDeviceInfo((String[])split);
        }
    }
}

