/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.cocosjs.banner;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.anythink.banner.api.ATBannerListener;
import com.anythink.banner.api.ATBannerView;
import com.anythink.cocosjs.utils.BaseHelper;
import com.anythink.cocosjs.utils.CommonUtil;
import com.anythink.cocosjs.utils.JSPluginUtil;
import com.anythink.cocosjs.utils.MsgTools;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.AdError;
import java.util.HashMap;
import org.cocos2dx.lib.Cocos2dxJavascriptJavaBridge;
import org.json.JSONObject;

public class BannerHelper
extends BaseHelper {
    private final String TAG = this.getClass().getSimpleName();
    Activity mActivity;
    String mPlacementId;
    boolean isReady;
    ATBannerView mBannerView;

    public BannerHelper() {
        MsgTools.pirntMsg(this.TAG + ": " + this);
        this.mActivity = JSPluginUtil.getActivity();
        this.mPlacementId = "";
    }

    @Override
    public void setAdListener(String callbackNameJson) {
        super.setAdListener(callbackNameJson);
    }

    public void initBanner(String placementId) {
        this.mPlacementId = placementId;
        MsgTools.pirntMsg("initBanner: " + placementId);
        this.mBannerView = new ATBannerView((Context)this.mActivity);
        this.mBannerView.setPlacementId(this.mPlacementId);
        this.mBannerView.setBannerAdListener(new ATBannerListener(){

            public void onBannerLoaded() {
                MsgTools.pirntMsg("onBannerLoaded: " + BannerHelper.this.mPlacementId);
                if (BannerHelper.this.hasCallbackName("BannerLoaded")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            BannerHelper.this.isReady = true;
                            Cocos2dxJavascriptJavaBridge.evalString((String)(BannerHelper.this.getCallbackName("BannerLoaded") + "('" + BannerHelper.this.mPlacementId + "');"));
                        }
                    });
                }
            }

            public void onBannerFailed(final AdError adError) {
                MsgTools.pirntMsg("onBannerFailed: " + BannerHelper.this.mPlacementId + ", " + adError.getFullErrorInfo());
                if (BannerHelper.this.hasCallbackName("BannerLoadFail")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            BannerHelper.this.isReady = false;
                            Cocos2dxJavascriptJavaBridge.evalString((String)(BannerHelper.this.getCallbackName("BannerLoadFail") + "('" + BannerHelper.this.mPlacementId + "','" + CommonUtil.getErrorMsg(adError) + "');"));
                        }
                    });
                }
            }

            public void onBannerClicked(final ATAdInfo adInfo) {
                MsgTools.pirntMsg("onBannerClicked: " + BannerHelper.this.mPlacementId);
                if (BannerHelper.this.hasCallbackName("BannerClick")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(BannerHelper.this.getCallbackName("BannerClick") + "('" + BannerHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onBannerShow(final ATAdInfo adInfo) {
                MsgTools.pirntMsg("onBannerShow: " + BannerHelper.this.mPlacementId);
                if (BannerHelper.this.hasCallbackName("BannerShow")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            BannerHelper.this.isReady = false;
                            Cocos2dxJavascriptJavaBridge.evalString((String)(BannerHelper.this.getCallbackName("BannerShow") + "('" + BannerHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onBannerClose(final ATAdInfo adInfo) {
                MsgTools.pirntMsg("onBannerClose: " + BannerHelper.this.mPlacementId);
                if (BannerHelper.this.hasCallbackName("BannerCloseButtonTapped")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            BannerHelper.this.isReady = false;
                            Cocos2dxJavascriptJavaBridge.evalString((String)(BannerHelper.this.getCallbackName("BannerCloseButtonTapped") + "('" + BannerHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onBannerAutoRefreshed(final ATAdInfo adInfo) {
                MsgTools.pirntMsg("onBannerAutoRefreshed: " + BannerHelper.this.mPlacementId);
                if (BannerHelper.this.hasCallbackName("BannerRefresh")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            BannerHelper.this.isReady = true;
                            Cocos2dxJavascriptJavaBridge.evalString((String)(BannerHelper.this.getCallbackName("BannerRefresh") + "('" + BannerHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onBannerAutoRefreshFail(final AdError adError) {
                MsgTools.pirntMsg("onBannerAutoRefreshFail: " + BannerHelper.this.mPlacementId + ", " + adError.getFullErrorInfo());
                if (BannerHelper.this.hasCallbackName("BannerRefreshFail")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            BannerHelper.this.isReady = false;
                            Cocos2dxJavascriptJavaBridge.evalString((String)(BannerHelper.this.getCallbackName("BannerRefreshFail") + "('" + BannerHelper.this.mPlacementId + "','" + CommonUtil.getErrorMsg(adError) + "');"));
                        }
                    });
                }
            }
        });
    }

    public void loadBanner(final String placementId, final String settings) {
        MsgTools.pirntMsg("loadBanner: " + placementId + ", settings - " + settings);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView == null) {
                    BannerHelper.this.initBanner(placementId);
                }
                if (!TextUtils.isEmpty((CharSequence)settings)) {
                    try {
                        JSONObject jsonObject = new JSONObject(settings);
                        int width = 0;
                        int height = 0;
                        if (jsonObject.has("width")) {
                            width = jsonObject.optInt("width");
                        }
                        if (jsonObject.has("height")) {
                            height = jsonObject.optInt("height");
                        }
                        if (BannerHelper.this.mBannerView != null) {
                            MsgTools.pirntMsg("loadBanner, width: " + width + ", height: " + height);
                            if (BannerHelper.this.mBannerView.getLayoutParams() == null) {
                                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(width, height);
                                BannerHelper.this.mBannerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                            } else {
                                BannerHelper.this.mBannerView.getLayoutParams().width = width;
                                BannerHelper.this.mBannerView.getLayoutParams().height = height;
                            }
                        }
                        HashMap localExtra = new HashMap();
                        BannerHelper.fillMapFromJsonObject(localExtra, jsonObject);
                        BannerHelper.this.mBannerView.setLocalExtra(localExtra);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                BannerHelper.this.mBannerView.loadAd();
            }
        });
    }

    public void showBannerWithRect(String rectJson, final String scenario) {
        MsgTools.pirntMsg("showBannerWithRect: " + this.mPlacementId + ", rect >>>" + rectJson + ", scenario: " + scenario);
        if (!TextUtils.isEmpty((CharSequence)rectJson)) {
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(rectJson);
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (jsonObject.has("x")) {
                    x = jsonObject.optInt("x");
                }
                if (jsonObject.has("y")) {
                    y = jsonObject.optInt("y");
                }
                if (jsonObject.has("width")) {
                    width = jsonObject.optInt("width");
                }
                if (jsonObject.has("height")) {
                    height = jsonObject.optInt("height");
                }
                final int finalWidth = width;
                final int finalHeight = height;
                final int finalX = x;
                final int finalY = y;
                JSPluginUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (BannerHelper.this.mBannerView != null) {
                            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(finalWidth, finalHeight);
                            layoutParams.leftMargin = finalX;
                            layoutParams.topMargin = finalY;
                            if (BannerHelper.this.mBannerView.getParent() != null) {
                                ((ViewGroup)BannerHelper.this.mBannerView.getParent()).removeView((View)BannerHelper.this.mBannerView);
                            }
                            if (!TextUtils.isEmpty((CharSequence)scenario)) {
                                BannerHelper.this.mBannerView.setScenario(scenario);
                            }
                            BannerHelper.this.mActivity.addContentView((View)BannerHelper.this.mBannerView, (ViewGroup.LayoutParams)layoutParams);
                        } else {
                            MsgTools.pirntMsg("showBannerWithRect error  ..you must call loadBanner first, placementId >>>  " + BannerHelper.this.mPlacementId);
                        }
                    }
                });
            }
            catch (Exception e) {
                MsgTools.pirntMsg("showBannerWithRect error: " + e.getMessage());
            }
        } else {
            MsgTools.pirntMsg("showBannerWithRect error without rect, placementId: " + this.mPlacementId);
        }
    }

    public void showBannerWithPosition(final String position, final String scenario) {
        MsgTools.pirntMsg("showBannerWithPostion: " + this.mPlacementId + ", position: " + position + ", scenario: " + scenario);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null) {
                    int width = 0;
                    int height = 0;
                    if (BannerHelper.this.mBannerView.getLayoutParams() != null) {
                        width = BannerHelper.this.mBannerView.getLayoutParams().width;
                        height = BannerHelper.this.mBannerView.getLayoutParams().height;
                    }
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
                    layoutParams.gravity = "top".equals(position) ? 49 : 81;
                    if (BannerHelper.this.mBannerView.getParent() != null) {
                        ((ViewGroup)BannerHelper.this.mBannerView.getParent()).removeView((View)BannerHelper.this.mBannerView);
                    }
                    if (!TextUtils.isEmpty((CharSequence)scenario)) {
                        BannerHelper.this.mBannerView.setScenario(scenario);
                    }
                    BannerHelper.this.mActivity.addContentView((View)BannerHelper.this.mBannerView, (ViewGroup.LayoutParams)layoutParams);
                } else {
                    MsgTools.pirntMsg("showBannerWithPostion error  ..you must call loadBanner first, placementId: " + BannerHelper.this.mPlacementId);
                }
            }
        });
    }

    public void reshowBanner() {
        MsgTools.pirntMsg("reshowBanner: " + this.mPlacementId);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null) {
                    BannerHelper.this.mBannerView.setVisibility(0);
                } else {
                    MsgTools.pirntMsg("reshowBanner error  ..you must call loadBanner first, placementId: " + BannerHelper.this.mPlacementId);
                }
            }
        });
    }

    public void hideBanner() {
        MsgTools.pirntMsg("hideBanner: " + this.mPlacementId);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null) {
                    BannerHelper.this.mBannerView.setVisibility(8);
                } else {
                    MsgTools.pirntMsg("hideBanner error  ..you must call loadBanner first, placementId: " + BannerHelper.this.mPlacementId);
                }
            }
        });
    }

    public void removeBanner() {
        MsgTools.pirntMsg("removeBanner: " + this.mPlacementId);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null && BannerHelper.this.mBannerView.getParent() != null) {
                    MsgTools.pirntMsg("removeBanner2 placementId: " + BannerHelper.this.mPlacementId);
                    ViewParent viewParent = BannerHelper.this.mBannerView.getParent();
                    ((ViewGroup)viewParent).removeView((View)BannerHelper.this.mBannerView);
                } else {
                    MsgTools.pirntMsg("removeBanner3 >>> no banner need to be removed, placementId: " + BannerHelper.this.mPlacementId);
                }
            }
        });
    }

    public boolean isAdReady() {
        ATAdStatusInfo atAdStatusInfo;
        if (this.mBannerView != null && (atAdStatusInfo = this.mBannerView.checkAdStatus()) != null) {
            boolean isReady = atAdStatusInfo.isReady();
            MsgTools.pirntMsg("banner isAdReady: " + this.mPlacementId + "\uff1a" + isReady);
        }
        return this.isReady;
    }

    public String checkAdStatus() {
        MsgTools.pirntMsg("banner checkAdStatus: " + this.mPlacementId);
        if (this.mBannerView != null) {
            ATAdStatusInfo atAdStatusInfo = this.mBannerView.checkAdStatus();
            boolean loading = atAdStatusInfo.isLoading();
            boolean ready = atAdStatusInfo.isReady();
            ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("isLoading", loading);
                jsonObject.put("isReady", ready);
                jsonObject.put("adInfo", (Object)atTopAdInfo);
                return jsonObject.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return "";
    }
}

