/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.cocosjs.interstitial;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.anythink.cocosjs.utils.BaseHelper;
import com.anythink.cocosjs.utils.CommonUtil;
import com.anythink.cocosjs.utils.JSPluginUtil;
import com.anythink.cocosjs.utils.MsgTools;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.AdError;
import com.anythink.interstitial.api.ATInterstitial;
import com.anythink.interstitial.api.ATInterstitialListener;
import java.util.HashMap;
import org.cocos2dx.lib.Cocos2dxJavascriptJavaBridge;
import org.json.JSONObject;

public class InterstitialHelper
extends BaseHelper {
    private static final String TAG = InterstitialHelper.class.getSimpleName();
    ATInterstitial mInterstitialAd;
    String mPlacementId;
    Activity mActivity;
    boolean isReady = false;

    public InterstitialHelper() {
        MsgTools.pirntMsg(TAG + ": " + this);
        this.mActivity = JSPluginUtil.getActivity();
    }

    @Override
    public void setAdListener(String callbackNameJson) {
        super.setAdListener(callbackNameJson);
    }

    private void initInterstitial(String placementId) {
        this.mPlacementId = placementId;
        MsgTools.pirntMsg("initInterstitial: " + this.mPlacementId);
        this.mInterstitialAd = new ATInterstitial((Context)this.mActivity, placementId);
        this.mInterstitialAd.setAdListener(new ATInterstitialListener(){

            public void onInterstitialAdLoaded() {
                MsgTools.pirntMsg("onInterstitialAdLoaded: " + InterstitialHelper.this.mPlacementId);
                if (InterstitialHelper.this.hasCallbackName("InterstitialLoaded")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            InterstitialHelper.this.isReady = true;
                            Cocos2dxJavascriptJavaBridge.evalString((String)(InterstitialHelper.this.getCallbackName("InterstitialLoaded") + "('" + InterstitialHelper.this.mPlacementId + "');"));
                        }
                    });
                }
            }

            public void onInterstitialAdLoadFail(final AdError adError) {
                MsgTools.pirntMsg("onInterstitialAdLoadFail: " + InterstitialHelper.this.mPlacementId + ", " + adError.getFullErrorInfo());
                if (InterstitialHelper.this.hasCallbackName("InterstitialLoadFail")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            InterstitialHelper.this.isReady = false;
                            Cocos2dxJavascriptJavaBridge.evalString((String)(InterstitialHelper.this.getCallbackName("InterstitialLoadFail") + "('" + InterstitialHelper.this.mPlacementId + "','" + CommonUtil.getErrorMsg(adError) + "');"));
                        }
                    });
                }
            }

            public void onInterstitialAdClicked(final ATAdInfo atAdInfo) {
                MsgTools.pirntMsg("onInterstitialAdClicked: " + InterstitialHelper.this.mPlacementId);
                if (InterstitialHelper.this.hasCallbackName("InterstitialClick")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(InterstitialHelper.this.getCallbackName("InterstitialClick") + "('" + InterstitialHelper.this.mPlacementId + "','" + atAdInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onInterstitialAdShow(final ATAdInfo atAdInfo) {
                MsgTools.pirntMsg("onInterstitialAdShow: " + InterstitialHelper.this.mPlacementId);
                if (InterstitialHelper.this.hasCallbackName("InterstitialAdShow")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(InterstitialHelper.this.getCallbackName("InterstitialAdShow") + "('" + InterstitialHelper.this.mPlacementId + "','" + atAdInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onInterstitialAdClose(final ATAdInfo atAdInfo) {
                MsgTools.pirntMsg("onInterstitialAdClose: " + InterstitialHelper.this.mPlacementId);
                if (InterstitialHelper.this.hasCallbackName("InterstitialClose")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(InterstitialHelper.this.getCallbackName("InterstitialClose") + "('" + InterstitialHelper.this.mPlacementId + "','" + atAdInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onInterstitialAdVideoStart(final ATAdInfo atAdInfo) {
                MsgTools.pirntMsg("onInterstitialAdVideoStart: " + InterstitialHelper.this.mPlacementId);
                if (InterstitialHelper.this.hasCallbackName("InterstitialPlayStart")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(InterstitialHelper.this.getCallbackName("InterstitialPlayStart") + "('" + InterstitialHelper.this.mPlacementId + "','" + atAdInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onInterstitialAdVideoEnd(final ATAdInfo atAdInfo) {
                MsgTools.pirntMsg("onInterstitialAdVideoEnd: " + InterstitialHelper.this.mPlacementId);
                if (InterstitialHelper.this.hasCallbackName("InterstitialPlayEnd")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(InterstitialHelper.this.getCallbackName("InterstitialPlayEnd") + "('" + InterstitialHelper.this.mPlacementId + "','" + atAdInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onInterstitialAdVideoError(final AdError adError) {
                MsgTools.pirntMsg("onInterstitialAdVideoError: " + InterstitialHelper.this.mPlacementId + ", " + adError.getFullErrorInfo());
                if (InterstitialHelper.this.hasCallbackName("InterstitialPlayFail")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(InterstitialHelper.this.getCallbackName("InterstitialPlayFail") + "('" + InterstitialHelper.this.mPlacementId + "','" + CommonUtil.getErrorMsg(adError) + "');"));
                        }
                    });
                }
            }
        });
    }

    public void loadInterstitial(final String placementId, final String settings) {
        MsgTools.pirntMsg("loadInterstitial: " + placementId + ", settings: " + settings);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (InterstitialHelper.this.mInterstitialAd == null) {
                    InterstitialHelper.this.initInterstitial(placementId);
                }
                if (!TextUtils.isEmpty((CharSequence)settings)) {
                    try {
                        JSONObject jsonObject = new JSONObject(settings);
                        HashMap<String, Boolean> localExtra = new HashMap<String, Boolean>();
                        if (jsonObject.has("UseRewardedVideoAsInterstitial") && ((Boolean)jsonObject.get("UseRewardedVideoAsInterstitial")).booleanValue()) {
                            localExtra.put("is_use_rewarded_video_as_interstitial", true);
                        }
                        InterstitialHelper.fillMapFromJsonObject(localExtra, jsonObject);
                        InterstitialHelper.this.mInterstitialAd.setLocalExtra(localExtra);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                InterstitialHelper.this.mInterstitialAd.load();
            }
        });
    }

    public void showInterstitial(final String scenario) {
        MsgTools.pirntMsg("showInterstitial: " + this.mPlacementId + ", scenario: " + scenario);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (InterstitialHelper.this.mInterstitialAd != null) {
                    InterstitialHelper.this.isReady = false;
                    InterstitialHelper.this.mInterstitialAd.show(InterstitialHelper.this.mActivity, scenario);
                } else {
                    MsgTools.pirntMsg("showInterstitial error, you must call loadRewardVideo first, placementId" + InterstitialHelper.this.mPlacementId);
                    if (InterstitialHelper.this.hasCallbackName("RewardedVideoLoadFail")) {
                        JSPluginUtil.runOnGLThread(new Runnable(){

                            @Override
                            public void run() {
                                Cocos2dxJavascriptJavaBridge.evalString((String)(InterstitialHelper.this.getCallbackName("RewardedVideoLoadFail") + "('" + InterstitialHelper.this.mPlacementId + "','you must call loadRewardVideo first');"));
                            }
                        });
                    }
                }
            }
        });
    }

    public boolean isAdReady() {
        MsgTools.pirntMsg("interstitial isAdReady: " + this.mPlacementId);
        try {
            if (this.mInterstitialAd != null) {
                boolean isAdReady = this.mInterstitialAd.isAdReady();
                MsgTools.pirntMsg("interstitial isAdReady: " + this.mPlacementId + ", " + isAdReady);
                return isAdReady;
            }
            MsgTools.pirntMsg("interstitial isAdReady error, you must call loadInterstitial first " + this.mPlacementId);
            MsgTools.pirntMsg("interstitial isAdReady, end: " + this.mPlacementId);
        }
        catch (Throwable e) {
            MsgTools.pirntMsg("interstitial isAdReady, Throwable: " + e.getMessage());
            return this.isReady;
        }
        return this.isReady;
    }

    public String checkAdStatus() {
        MsgTools.pirntMsg("interstitial checkAdStatus: " + this.mPlacementId);
        if (this.mInterstitialAd != null) {
            ATAdStatusInfo atAdStatusInfo = this.mInterstitialAd.checkAdStatus();
            boolean loading = atAdStatusInfo.isLoading();
            boolean ready = atAdStatusInfo.isReady();
            ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("isLoading", loading);
                jsonObject.put("isReady", ready);
                jsonObject.put("adInfo", (Object)atTopAdInfo);
                return jsonObject.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return "";
    }
}

