/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.cocosjs.nativead;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.anythink.cocosjs.nativead.ViewInfo;
import com.anythink.cocosjs.utils.CommonUtil;
import com.anythink.cocosjs.utils.MsgTools;
import com.anythink.nativead.api.ATNativeAdRenderer;
import com.anythink.nativead.api.ATNativeImageView;
import com.anythink.nativead.unitgroup.api.CustomNativeAd;
import java.util.ArrayList;
import java.util.List;

public class ATUnityRender
implements ATNativeAdRenderer<CustomNativeAd> {
    Activity mActivity;
    ViewInfo mViewInfo;
    FrameLayout mFrameLayout;
    View mDislikeView;
    List<View> mClickViews = new ArrayList<View>();
    int mNetworkType;

    public ATUnityRender(Activity pActivity, ViewInfo pViewInfo) {
        this.mActivity = pActivity;
        this.mViewInfo = pViewInfo;
    }

    public View createView(Context context, int networkType) {
        this.mNetworkType = networkType;
        this.mFrameLayout = new FrameLayout(context);
        return this.mFrameLayout;
    }

    public void renderAdView(View view, CustomNativeAd ad) {
        CustomNativeAd.ExtraInfo.Builder builder;
        TextView titleView = new TextView((Context)this.mActivity);
        TextView descView = new TextView((Context)this.mActivity);
        TextView ctaView = new TextView((Context)this.mActivity);
        View mediaView = ad.getAdMediaView(new Object[]{this.mFrameLayout, view.getWidth()});
        if (mediaView != null && ad.isNativeExpress()) {
            if (this.mDislikeView != null) {
                this.mDislikeView.setVisibility(8);
            }
            if (this.mViewInfo.imgMainView != null && this.mViewInfo.rootView != null) {
                this.mViewInfo.imgMainView.mX = 0;
                this.mViewInfo.imgMainView.mY = 0;
                this.mViewInfo.imgMainView.mWidth = this.mViewInfo.rootView.mWidth;
                this.mViewInfo.imgMainView.mHeight = this.mViewInfo.rootView.mHeight;
                MsgTools.pirntMsg("ExpressNative, NetworkType ----> " + this.mNetworkType);
                ViewInfo.add2ParentView(this.mFrameLayout, mediaView, this.mViewInfo.imgMainView, -1);
                return;
            }
        }
        if (this.mViewInfo.titleView != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mViewInfo.titleView.textcolor)) {
                titleView.setTextColor(Color.parseColor((String)this.mViewInfo.titleView.textcolor));
            }
            if (this.mViewInfo.titleView.textSize > 0) {
                titleView.setTextSize(0, (float)this.mViewInfo.titleView.textSize);
            }
            MsgTools.pirntMsg("title---->" + ad.getTitle());
            titleView.setText((CharSequence)ad.getTitle());
            titleView.setSingleLine();
            titleView.setMaxEms(15);
            titleView.setEllipsize(TextUtils.TruncateAt.END);
            ViewInfo.add2ParentView(this.mFrameLayout, (View)titleView, this.mViewInfo.titleView, -1);
        }
        if (this.mViewInfo.ctaView != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mViewInfo.ctaView.textcolor)) {
                ctaView.setTextColor(Color.parseColor((String)this.mViewInfo.ctaView.textcolor));
            }
            if (this.mViewInfo.ctaView.textSize > 0) {
                ctaView.setTextSize(0, (float)this.mViewInfo.ctaView.textSize);
            }
            ctaView.setGravity(17);
            ctaView.setSingleLine();
            ctaView.setMaxEms(15);
            ctaView.setEllipsize(TextUtils.TruncateAt.END);
            MsgTools.pirntMsg("cat---->" + ad.getCallToActionText());
            ctaView.setText((CharSequence)ad.getCallToActionText());
            ViewInfo.add2ParentView(this.mFrameLayout, (View)ctaView, this.mViewInfo.ctaView, -1);
        }
        if (this.mViewInfo.descView != null && descView != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mViewInfo.descView.textcolor)) {
                descView.setTextColor(Color.parseColor((String)this.mViewInfo.descView.textcolor));
            }
            if (this.mViewInfo.descView.textSize > 0) {
                descView.setTextSize(0, (float)this.mViewInfo.descView.textSize);
            }
            MsgTools.pirntMsg("desc---->" + ad.getDescriptionText());
            descView.setText((CharSequence)ad.getDescriptionText());
            descView.setMaxLines(3);
            descView.setMaxEms(15);
            descView.setEllipsize(TextUtils.TruncateAt.END);
            ViewInfo.add2ParentView(this.mFrameLayout, (View)descView, this.mViewInfo.descView, -1);
        }
        ATNativeImageView iconView = null;
        if (this.mViewInfo.IconView != null) {
            FrameLayout iconArea = new FrameLayout((Context)this.mActivity);
            if (ad.getAdIconView() == null) {
                iconView = new ATNativeImageView((Context)this.mActivity);
                iconArea.addView((View)iconView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                iconView.setImage(ad.getIconImageUrl());
            } else {
                iconArea.addView(ad.getAdIconView(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }
            ViewInfo.add2ParentView(this.mFrameLayout, (View)iconArea, this.mViewInfo.IconView, -1);
        }
        ATNativeImageView logoView = null;
        if (this.mViewInfo.adLogoView != null) {
            logoView = new ATNativeImageView((Context)this.mActivity);
            ViewInfo.add2ParentView(this.mFrameLayout, (View)logoView, this.mViewInfo.adLogoView, -1);
            logoView.setImage(ad.getAdChoiceIconUrl());
        }
        if (mediaView != null) {
            MsgTools.pirntMsg("mediaView ---> \u89c6\u5c4f\u64ad\u653e " + ad.getVideoUrl());
            if (this.mViewInfo.imgMainView != null) {
                ViewInfo.add2ParentView(this.mFrameLayout, mediaView, this.mViewInfo.imgMainView, -1);
            }
        } else {
            MsgTools.pirntMsg("mediaView ---> \u5927\u56fe\u64ad\u653e");
            ATNativeImageView mainImageView = new ATNativeImageView((Context)this.mActivity);
            if (this.mViewInfo.imgMainView != null) {
                ViewInfo.add2ParentView(this.mFrameLayout, (View)mainImageView, this.mViewInfo.imgMainView, -1);
                mainImageView.setImage(ad.getMainImageUrl());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)ad.getAdFrom()) && this.mNetworkType == 23) {
            FrameLayout.LayoutParams adFromParam = new FrameLayout.LayoutParams(-2, -2);
            adFromParam.leftMargin = CommonUtil.dip2px((Context)this.mActivity, 3.0f);
            adFromParam.bottomMargin = CommonUtil.dip2px((Context)this.mActivity, 3.0f);
            adFromParam.gravity = 80;
            TextView adFromTextView = new TextView((Context)this.mActivity);
            adFromTextView.setTextSize(1, 6.0f);
            adFromTextView.setPadding(CommonUtil.dip2px((Context)this.mActivity, 5.0f), CommonUtil.dip2px((Context)this.mActivity, 2.0f), CommonUtil.dip2px((Context)this.mActivity, 5.0f), CommonUtil.dip2px((Context)this.mActivity, 2.0f));
            adFromTextView.setBackgroundColor(-7829368);
            adFromTextView.setTextColor(-1);
            adFromTextView.setText((CharSequence)ad.getAdFrom());
            this.mFrameLayout.addView((View)adFromTextView, (ViewGroup.LayoutParams)adFromParam);
        }
        if (this.mNetworkType == 2) {
            MsgTools.pirntMsg("start to add admob ad textview ");
            TextView adLogoView = new TextView((Context)this.mActivity);
            adLogoView.setTextColor(-1);
            adLogoView.setText((CharSequence)"AD");
            adLogoView.setTextSize(11.0f);
            adLogoView.setPadding(CommonUtil.dip2px((Context)this.mActivity, 3.0f), 0, CommonUtil.dip2px((Context)this.mActivity, 3.0f), 0);
            adLogoView.setBackgroundColor(Color.parseColor((String)"#66000000"));
            if (this.mFrameLayout != null) {
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
                layoutParams.leftMargin = CommonUtil.dip2px((Context)this.mActivity, 3.0f);
                layoutParams.topMargin = CommonUtil.dip2px((Context)this.mActivity, 3.0f);
                this.mFrameLayout.addView((View)adLogoView, (ViewGroup.LayoutParams)layoutParams);
                MsgTools.pirntMsg("add admob ad textview 2 activity");
            }
        }
        ArrayList<View> customClickViews = new ArrayList<View>();
        if (this.mViewInfo.rootView != null) {
            this.dealWithClick(view, this.mViewInfo.rootView.isCustomClick, this.mClickViews, customClickViews, "root");
        }
        if (this.mViewInfo.titleView != null) {
            this.dealWithClick((View)titleView, this.mViewInfo.titleView.isCustomClick, this.mClickViews, customClickViews, "title");
        }
        if (this.mViewInfo.descView != null) {
            this.dealWithClick((View)descView, this.mViewInfo.descView.isCustomClick, this.mClickViews, customClickViews, "desc");
        }
        if (this.mViewInfo.IconView != null) {
            this.dealWithClick((View)iconView, this.mViewInfo.IconView.isCustomClick, this.mClickViews, customClickViews, "icon");
        }
        if (this.mViewInfo.adLogoView != null) {
            this.dealWithClick((View)logoView, this.mViewInfo.adLogoView.isCustomClick, this.mClickViews, customClickViews, "adLogo");
        }
        if (this.mViewInfo.ctaView != null) {
            this.dealWithClick((View)ctaView, this.mViewInfo.ctaView.isCustomClick, this.mClickViews, customClickViews, "cta");
        }
        if (this.mDislikeView != null) {
            MsgTools.pirntMsg("bind dislike ----> " + this.mNetworkType);
            this.mDislikeView.setVisibility(0);
            builder = new CustomNativeAd.ExtraInfo.Builder();
            builder.setCloseView(this.mDislikeView);
            if (customClickViews.size() > 0) {
                builder.setCustomViewList(customClickViews);
            }
            ad.setExtraInfo(builder.build());
        } else if (customClickViews.size() > 0) {
            builder = new CustomNativeAd.ExtraInfo.Builder().setCustomViewList(customClickViews);
            ad.setExtraInfo(builder.build());
        }
    }

    public void setDislikeView(View dislikeView) {
        this.mDislikeView = dislikeView;
    }

    private void dealWithClick(View view, boolean isCustomClick, List<View> clickViews, List<View> customClickViews, String name) {
        if ((this.mNetworkType == 8 || this.mNetworkType == 22) && isCustomClick) {
            if (view != null) {
                MsgTools.pirntMsg("add customClick ----> " + name);
                customClickViews.add(view);
            }
            return;
        }
        MsgTools.pirntMsg("add click ----> " + name);
        clickViews.add(view);
    }

    public List<View> getClickViews() {
        return this.mClickViews;
    }
}

