/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.cocosjs.nativead;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.anythink.cocosjs.nativead.ATUnityRender;
import com.anythink.cocosjs.nativead.ViewInfo;
import com.anythink.cocosjs.utils.BaseHelper;
import com.anythink.cocosjs.utils.CommonUtil;
import com.anythink.cocosjs.utils.JSPluginUtil;
import com.anythink.cocosjs.utils.MsgTools;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.AdError;
import com.anythink.nativead.api.ATNative;
import com.anythink.nativead.api.ATNativeAdRenderer;
import com.anythink.nativead.api.ATNativeAdView;
import com.anythink.nativead.api.ATNativeDislikeListener;
import com.anythink.nativead.api.ATNativeEventListener;
import com.anythink.nativead.api.ATNativeNetworkListener;
import com.anythink.nativead.api.NativeAd;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cocos2dx.lib.Cocos2dxJavascriptJavaBridge;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeHelper
extends BaseHelper {
    private final String TAG = this.getClass().getSimpleName();
    Activity mActivity;
    String mPlacementId;
    ATNative mATNative;
    ATNativeAdView mATNativeAdView;
    NativeAd mNativeAd;
    ViewInfo pViewInfo;
    static List<ViewInfo> currViewInfo = new ArrayList<ViewInfo>();
    ImageView mDislikeView;

    public NativeHelper() {
        MsgTools.pirntMsg(this.TAG + ": " + this);
        this.mActivity = JSPluginUtil.getActivity();
        this.mPlacementId = "";
    }

    @Override
    public void setAdListener(String callbackNameJson) {
        super.setAdListener(callbackNameJson);
    }

    private void initNative(String placementId) {
        this.mPlacementId = placementId;
        MsgTools.pirntMsg("initNative: " + placementId);
        this.mATNative = new ATNative((Context)this.mActivity, placementId, new ATNativeNetworkListener(){

            public void onNativeAdLoaded() {
                MsgTools.pirntMsg("onNativeAdLoaded: " + NativeHelper.this.mPlacementId);
                if (NativeHelper.this.hasCallbackName("NativeLoaded")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(NativeHelper.this.getCallbackName("NativeLoaded") + "('" + NativeHelper.this.mPlacementId + "');"));
                        }
                    });
                }
            }

            public void onNativeAdLoadFail(final AdError adError) {
                MsgTools.pirntMsg("onNativeAdLoadFail: " + NativeHelper.this.mPlacementId + ", " + adError.getFullErrorInfo());
                if (NativeHelper.this.hasCallbackName("NativeLoadFail")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(NativeHelper.this.getCallbackName("NativeLoadFail") + "('" + NativeHelper.this.mPlacementId + "','" + CommonUtil.getErrorMsg(adError) + "');"));
                        }
                    });
                }
            }
        });
        this.mATNativeAdView = new ATNativeAdView((Context)this.mActivity);
    }

    public void loadNative(final String placementId, final String settings) {
        MsgTools.pirntMsg("loadNative: " + placementId + ", settings: " + settings);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (NativeHelper.this.mATNative == null || !TextUtils.equals((CharSequence)NativeHelper.this.mPlacementId, (CharSequence)placementId)) {
                    NativeHelper.this.initNative(placementId);
                }
                if (!TextUtils.isEmpty((CharSequence)settings)) {
                    try {
                        JSONObject jsonObject = new JSONObject(settings);
                        int width = 0;
                        int height = 0;
                        HashMap<String, Integer> localExtra = new HashMap<String, Integer>();
                        if (jsonObject.has("width")) {
                            width = jsonObject.optInt("width");
                            localExtra.put("key_width", width);
                            localExtra.put("tt_image_width", width);
                            localExtra.put("mintegral_auto_render_native_width", width);
                        }
                        if (jsonObject.has("height")) {
                            height = jsonObject.optInt("height");
                            localExtra.put("key_height", height);
                            localExtra.put("tt_image_height", height);
                            localExtra.put("mintegral_auto_render_native_height", height);
                        }
                        MsgTools.pirntMsg("native setLocalExtra >>>  width: " + width + ", height: " + height);
                        NativeHelper.fillMapFromJsonObject(localExtra, jsonObject);
                        NativeHelper.this.mATNative.setLocalExtra(localExtra);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                NativeHelper.this.mATNative.makeAdRequest();
            }
        });
    }

    private ViewInfo parseViewInfo(String showConfig) {
        this.pViewInfo = new ViewInfo();
        if (TextUtils.isEmpty((CharSequence)showConfig)) {
            Log.e((String)this.TAG, (String)"showConfig is null ,user defult");
            this.pViewInfo = ViewInfo.createDefualtView(this.mActivity);
        }
        try {
            String tempjson;
            JSONObject _jsonObject = new JSONObject(showConfig);
            if (_jsonObject.has("parent")) {
                tempjson = _jsonObject.getString("parent");
                MsgTools.pirntMsg("parent----> " + tempjson);
                this.pViewInfo.rootView = this.pViewInfo.parseINFO(tempjson, "parent", 0, 0);
            }
            if (_jsonObject.has("icon")) {
                tempjson = _jsonObject.getString("icon");
                MsgTools.pirntMsg("appIcon----> " + tempjson);
                this.pViewInfo.IconView = this.pViewInfo.parseINFO(tempjson, "appIcon", 0, 0);
            }
            if (_jsonObject.has("mainImage")) {
                tempjson = _jsonObject.getString("mainImage");
                MsgTools.pirntMsg("mainImage----> " + tempjson);
                this.pViewInfo.imgMainView = this.pViewInfo.parseINFO(tempjson, "mainImage", 0, 0);
            }
            if (_jsonObject.has("title")) {
                tempjson = _jsonObject.getString("title");
                MsgTools.pirntMsg("title----> " + tempjson);
                this.pViewInfo.titleView = this.pViewInfo.parseINFO(tempjson, "title", 0, 0);
            }
            if (_jsonObject.has("desc")) {
                tempjson = _jsonObject.getString("desc");
                MsgTools.pirntMsg("desc----> " + tempjson);
                this.pViewInfo.descView = this.pViewInfo.parseINFO(tempjson, "desc", 0, 0);
            }
            if (_jsonObject.has("adLogo")) {
                tempjson = _jsonObject.getString("adLogo");
                MsgTools.pirntMsg("adLogo----> " + tempjson);
                this.pViewInfo.adLogoView = this.pViewInfo.parseINFO(tempjson, "adLogo", 0, 0);
            }
            if (_jsonObject.has("cta")) {
                tempjson = _jsonObject.getString("cta");
                MsgTools.pirntMsg("cta----> " + tempjson);
                this.pViewInfo.ctaView = this.pViewInfo.parseINFO(tempjson, "cta", 0, 0);
            }
            if (_jsonObject.has("dislike")) {
                tempjson = _jsonObject.getString("dislike");
                MsgTools.pirntMsg("dislike----> " + tempjson);
                this.pViewInfo.dislikeView = this.pViewInfo.parseINFO(tempjson, "dislike", 0, 0);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.pViewInfo;
    }

    public void show(final String showConfig, final String scenario) {
        MsgTools.pirntMsg("native show: " + this.mPlacementId + ", config: " + showConfig + ", scenario: " + scenario);
        if (this.mATNative == null) {
            MsgTools.pirntMsg("native show error: mATNative = null");
            return;
        }
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                NativeAd nativeAd = !TextUtils.isEmpty((CharSequence)scenario) ? NativeHelper.this.mATNative.getNativeAd(scenario) : NativeHelper.this.mATNative.getNativeAd();
                if (nativeAd != null) {
                    MsgTools.pirntMsg("nativeAd:" + nativeAd.toString());
                    NativeHelper.this.pViewInfo = NativeHelper.this.parseViewInfo(showConfig);
                    currViewInfo.add(NativeHelper.this.pViewInfo);
                    NativeHelper.this.mNativeAd = nativeAd;
                    nativeAd.setNativeEventListener(new ATNativeEventListener(){

                        public void onAdImpressed(ATNativeAdView view, final ATAdInfo adInfo) {
                            MsgTools.pirntMsg("onAdImpressed: " + NativeHelper.this.mPlacementId);
                            if (NativeHelper.this.hasCallbackName("NativeShow")) {
                                JSPluginUtil.runOnGLThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        Cocos2dxJavascriptJavaBridge.evalString((String)(NativeHelper.this.getCallbackName("NativeShow") + "('" + NativeHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                                    }
                                });
                            }
                        }

                        public void onAdClicked(ATNativeAdView view, final ATAdInfo adInfo) {
                            MsgTools.pirntMsg("onAdClicked: " + NativeHelper.this.mPlacementId);
                            if (NativeHelper.this.hasCallbackName("NativeClick")) {
                                JSPluginUtil.runOnGLThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        Cocos2dxJavascriptJavaBridge.evalString((String)(NativeHelper.this.getCallbackName("NativeClick") + "('" + NativeHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                                    }
                                });
                            }
                        }

                        public void onAdVideoStart(ATNativeAdView view) {
                            MsgTools.pirntMsg("onAdVideoStart: " + NativeHelper.this.mPlacementId);
                            if (NativeHelper.this.hasCallbackName("NativeVideoStart")) {
                                JSPluginUtil.runOnGLThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        Cocos2dxJavascriptJavaBridge.evalString((String)(NativeHelper.this.getCallbackName("NativeVideoStart") + "('" + NativeHelper.this.mPlacementId + "');"));
                                    }
                                });
                            }
                        }

                        public void onAdVideoEnd(ATNativeAdView view) {
                            MsgTools.pirntMsg("onAdVideoEnd: " + NativeHelper.this.mPlacementId);
                            if (NativeHelper.this.hasCallbackName("NativeVideoEnd")) {
                                JSPluginUtil.runOnGLThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        Cocos2dxJavascriptJavaBridge.evalString((String)(NativeHelper.this.getCallbackName("NativeVideoEnd") + "('" + NativeHelper.this.mPlacementId + "');"));
                                    }
                                });
                            }
                        }

                        public void onAdVideoProgress(ATNativeAdView view, final int progress) {
                            if (NativeHelper.this.hasCallbackName("NativeVideoProgress")) {
                                JSPluginUtil.runOnGLThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        Cocos2dxJavascriptJavaBridge.evalString((String)(NativeHelper.this.getCallbackName("NativeVideoProgress") + "('" + NativeHelper.this.mPlacementId + "','" + progress + "');"));
                                    }
                                });
                            }
                        }
                    });
                    nativeAd.setDislikeCallbackListener(new ATNativeDislikeListener(){

                        public void onAdCloseButtonClick(ATNativeAdView atNativeAdView, final ATAdInfo atAdInfo) {
                            MsgTools.pirntMsg("onAdCloseButtonClick: " + NativeHelper.this.mPlacementId);
                            if (NativeHelper.this.hasCallbackName("NativeCloseButtonTapped")) {
                                JSPluginUtil.runOnGLThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        Cocos2dxJavascriptJavaBridge.evalString((String)(NativeHelper.this.getCallbackName("NativeCloseButtonTapped") + "('" + NativeHelper.this.mPlacementId + "','" + atAdInfo.toString() + "');"));
                                    }
                                });
                            }
                        }
                    });
                    ATUnityRender atUnityRender = new ATUnityRender(NativeHelper.this.mActivity, NativeHelper.this.pViewInfo);
                    try {
                        if (NativeHelper.this.pViewInfo.dislikeView != null) {
                            NativeHelper.this.initDislikeView(NativeHelper.this.pViewInfo.dislikeView);
                            atUnityRender.setDislikeView((View)NativeHelper.this.mDislikeView);
                        }
                        nativeAd.renderAdView(NativeHelper.this.mATNativeAdView, (ATNativeAdRenderer)atUnityRender);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (NativeHelper.this.pViewInfo.dislikeView != null && NativeHelper.this.mDislikeView != null) {
                        if (NativeHelper.this.mDislikeView.getParent() != null) {
                            ((ViewGroup)NativeHelper.this.mDislikeView.getParent()).removeView((View)NativeHelper.this.mDislikeView);
                        }
                        NativeHelper.this.mATNativeAdView.addView((View)NativeHelper.this.mDislikeView);
                    }
                    if (NativeHelper.this.pViewInfo.adLogoView != null) {
                        FrameLayout.LayoutParams adLogoLayoutParams = new FrameLayout.LayoutParams(NativeHelper.this.pViewInfo.adLogoView.mWidth, NativeHelper.this.pViewInfo.adLogoView.mHeight);
                        adLogoLayoutParams.leftMargin = NativeHelper.this.pViewInfo.adLogoView.mX;
                        adLogoLayoutParams.topMargin = NativeHelper.this.pViewInfo.adLogoView.mY;
                        nativeAd.prepare(NativeHelper.this.mATNativeAdView, atUnityRender.getClickViews(), adLogoLayoutParams);
                    } else {
                        nativeAd.prepare(NativeHelper.this.mATNativeAdView, atUnityRender.getClickViews(), null);
                    }
                    ViewInfo.addNativeAdView2Activity(NativeHelper.this.mActivity, NativeHelper.this.pViewInfo, NativeHelper.this.mATNativeAdView);
                } else if (NativeHelper.this.hasCallbackName("NativeLoadFail")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(NativeHelper.this.getCallbackName("NativeLoadFail") + "('" + NativeHelper.this.mPlacementId + "','showNative error, nativeAd = null');"));
                        }
                    });
                }
            }
        });
    }

    private void initDislikeView(ViewInfo.INFO dislikeInfo) {
        if (this.mDislikeView == null) {
            this.mDislikeView = new ImageView((Context)this.mActivity);
            this.mDislikeView.setImageResource(CommonUtil.getResId((Context)this.mActivity, "btn_close", "drawable"));
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(dislikeInfo.mWidth, dislikeInfo.mHeight);
        layoutParams.leftMargin = dislikeInfo.mX;
        layoutParams.topMargin = dislikeInfo.mY;
        if (!TextUtils.isEmpty((CharSequence)dislikeInfo.bgcolor)) {
            this.mDislikeView.setBackgroundColor(Color.parseColor((String)dislikeInfo.bgcolor));
        }
        this.mDislikeView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public boolean isAdReady() {
        if (this.mATNative == null) {
            MsgTools.pirntMsg("isAdReady error  ..you must call initNative first " + this.mPlacementId);
            return false;
        }
        ATAdStatusInfo atAdStatusInfo = this.mATNative.checkAdStatus();
        if (atAdStatusInfo != null) {
            boolean isReady = atAdStatusInfo.isReady();
            MsgTools.pirntMsg("native isAdReady: " + this.mPlacementId + ", " + isReady);
            return isReady;
        }
        return false;
    }

    public void clean() {
        if (this.mNativeAd != null) {
            this.mNativeAd.destory();
        }
    }

    public void remove() {
        MsgTools.pirntMsg("native remove: " + this.mPlacementId);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ViewGroup _viewGroup;
                    if (NativeHelper.this.mATNativeAdView != null && (_viewGroup = (ViewGroup)NativeHelper.this.mATNativeAdView.getParent()) != null) {
                        _viewGroup.removeView((View)NativeHelper.this.mATNativeAdView);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void onPause() {
        if (this.mNativeAd != null) {
            this.mNativeAd.onPause();
        }
    }

    public void onResume() {
        if (this.mNativeAd != null) {
            this.mNativeAd.onResume();
        }
    }

    public String checkAdStatus() {
        MsgTools.pirntMsg("native checkAdStatus: " + this.mPlacementId);
        if (this.mATNative != null) {
            ATAdStatusInfo atAdStatusInfo = this.mATNative.checkAdStatus();
            boolean loading = atAdStatusInfo.isLoading();
            boolean ready = atAdStatusInfo.isReady();
            ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("isLoading", loading);
                jsonObject.put("isReady", ready);
                jsonObject.put("adInfo", (Object)atTopAdInfo);
                return jsonObject.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return "";
    }
}

