/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.cocosjs.nativead;

import android.app.Activity;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.anythink.nativead.api.ATNativeAdView;
import org.json.JSONException;
import org.json.JSONObject;

public class ViewInfo {
    public INFO rootView;
    public INFO imgMainView;
    public INFO IconView;
    public INFO titleView;
    public INFO descView;
    public INFO adLogoView;
    public INFO ctaView;
    public INFO dislikeView;

    public static void add2ParentView(FrameLayout view, View childView, INFO pViewInfo, int gravity) {
        if (view == null || pViewInfo == null) {
            return;
        }
        if (childView == null || pViewInfo.mWidth < 0 || pViewInfo.mHeight < 0) {
            Log.e((String)("add2activity--[" + pViewInfo.name + "]"), (String)" config error ,show error !");
            return;
        }
        Log.i((String)"add2activity", (String)("[" + pViewInfo.name + "]   add 2 activity"));
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(pViewInfo.mWidth, pViewInfo.mHeight);
        layoutParams.leftMargin = pViewInfo.mX;
        layoutParams.topMargin = pViewInfo.mY;
        layoutParams.gravity = gravity > 0 ? gravity : 51;
        childView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        try {
            if (!TextUtils.isEmpty((CharSequence)pViewInfo.bgcolor)) {
                childView.setBackgroundColor(Color.parseColor((String)pViewInfo.bgcolor));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        view.addView(childView, (ViewGroup.LayoutParams)layoutParams);
    }

    public static void addNativeAdView2Activity(final Activity pActivity, final ViewInfo pViewInfo, final ATNativeAdView mATNativeAdView) {
        if (pActivity == null || mATNativeAdView == null) {
            return;
        }
        pActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ViewGroup _viewGroup = (ViewGroup)mATNativeAdView.getParent();
                    if (_viewGroup != null) {
                        _viewGroup.removeView((View)mATNativeAdView);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (pViewInfo.rootView != null) {
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(pViewInfo.rootView.mWidth, pViewInfo.rootView.mHeight);
                    layoutParams.leftMargin = pViewInfo.rootView.mX;
                    layoutParams.topMargin = pViewInfo.rootView.mY;
                    if (!TextUtils.isEmpty((CharSequence)pViewInfo.rootView.bgcolor)) {
                        mATNativeAdView.setBackgroundColor(Color.parseColor((String)pViewInfo.rootView.bgcolor));
                    }
                    pActivity.addContentView((View)mATNativeAdView, (ViewGroup.LayoutParams)layoutParams);
                }
            }
        });
    }

    public static ViewInfo createDefualtView(Activity pActivity) {
        DisplayMetrics dm = pActivity.getResources().getDisplayMetrics();
        int heigth = dm.heightPixels;
        int width = dm.widthPixels;
        ViewInfo _viewInfo = new ViewInfo();
        _viewInfo.rootView.textSize = 12;
        _viewInfo.rootView.textcolor = "0X000000";
        _viewInfo.rootView.bgcolor = "0XFFFFFF";
        _viewInfo.rootView.mWidth = width;
        _viewInfo.rootView.mHeight = heigth / 5;
        _viewInfo.rootView.mX = 0;
        _viewInfo.rootView.mY = 0;
        _viewInfo.rootView.name = "rootView_def";
        _viewInfo.imgMainView.textSize = 12;
        _viewInfo.imgMainView.textcolor = "0X000000";
        _viewInfo.imgMainView.bgcolor = "0XFFFFFF";
        _viewInfo.imgMainView.mWidth = 25;
        _viewInfo.imgMainView.mHeight = 25;
        _viewInfo.imgMainView.mX = _viewInfo.rootView.mX + 0;
        _viewInfo.imgMainView.mY = _viewInfo.rootView.mX + 0;
        _viewInfo.imgMainView.name = "imgMainView_def";
        _viewInfo.adLogoView.textSize = 12;
        _viewInfo.adLogoView.textcolor = "0X000000";
        _viewInfo.adLogoView.bgcolor = "0XFFFFFF";
        _viewInfo.adLogoView.mWidth = _viewInfo.rootView.mWidth * 3 / 5;
        _viewInfo.adLogoView.mHeight = _viewInfo.rootView.mHeight / 2;
        _viewInfo.adLogoView.mX = _viewInfo.rootView.mX + 100;
        _viewInfo.adLogoView.mY = _viewInfo.rootView.mX + 10;
        _viewInfo.adLogoView.name = "adlogo_def";
        _viewInfo.IconView.textSize = 12;
        _viewInfo.IconView.textcolor = "0X000000";
        _viewInfo.IconView.bgcolor = "0XFFFFFF";
        _viewInfo.IconView.mWidth = 25;
        _viewInfo.IconView.mHeight = 25;
        _viewInfo.IconView.mX = _viewInfo.rootView.mX + 0;
        _viewInfo.IconView.mY = _viewInfo.rootView.mX + 0;
        _viewInfo.IconView.name = "appicon_def";
        _viewInfo.titleView.textSize = 12;
        _viewInfo.titleView.textcolor = "0X000000";
        _viewInfo.titleView.bgcolor = "0XFFFFFF";
        _viewInfo.titleView.mWidth = 25;
        _viewInfo.titleView.mHeight = 25;
        _viewInfo.titleView.mX = _viewInfo.rootView.mX + 0;
        _viewInfo.titleView.mY = _viewInfo.rootView.mX + 0;
        _viewInfo.descView.textSize = 12;
        _viewInfo.descView.textcolor = "0X000000";
        _viewInfo.descView.bgcolor = "0XFFFFFF";
        _viewInfo.descView.mWidth = 25;
        _viewInfo.descView.mHeight = 25;
        _viewInfo.descView.mX = _viewInfo.rootView.mX + 0;
        _viewInfo.descView.mY = _viewInfo.rootView.mX + 0;
        _viewInfo.descView.name = "desc_def";
        _viewInfo.ctaView.textSize = 12;
        _viewInfo.ctaView.textcolor = "0X000000";
        _viewInfo.ctaView.bgcolor = "0XFFFFFF";
        _viewInfo.ctaView.mWidth = 25;
        _viewInfo.ctaView.mHeight = 25;
        _viewInfo.ctaView.mX = _viewInfo.rootView.mX + 0;
        _viewInfo.ctaView.mY = _viewInfo.rootView.mX + 0;
        _viewInfo.ctaView.name = "cta_def";
        return _viewInfo;
    }

    public INFO parseINFO(String json, String name, int px, int py) throws JSONException {
        INFO _info = new INFO();
        JSONObject _jsonObject = new JSONObject(json);
        if (_jsonObject.has("x")) {
            _info.mX = _jsonObject.getInt("x") + px;
        }
        if (_jsonObject.has("y")) {
            _info.mY = _jsonObject.getInt("y") + py;
        }
        if (_jsonObject.has("width")) {
            _info.mWidth = _jsonObject.getInt("width");
        }
        if (_jsonObject.has("height")) {
            _info.mHeight = _jsonObject.getInt("height");
        }
        if (_jsonObject.has("backgroundColor")) {
            _info.bgcolor = _jsonObject.getString("backgroundColor");
        }
        if (_jsonObject.has("textColor")) {
            _info.textcolor = _jsonObject.getString("textColor");
        }
        if (_jsonObject.has("textSize")) {
            _info.textSize = _jsonObject.getInt("textSize");
        }
        if (_jsonObject.has("isCustomClick")) {
            _info.isCustomClick = _jsonObject.getBoolean("isCustomClick");
        }
        _info.name = name;
        return _info;
    }

    protected class INFO {
        protected int mX = 0;
        protected int mY = 0;
        protected int mWidth = 0;
        protected int mHeight = 0;
        protected String bgcolor = "";
        protected int textSize = 0;
        protected String textcolor = "";
        protected boolean isCustomClick = false;
        protected String name;
    }
}

