/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.cocosjs.rewardvideo;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.anythink.cocosjs.utils.BaseHelper;
import com.anythink.cocosjs.utils.CommonUtil;
import com.anythink.cocosjs.utils.JSPluginUtil;
import com.anythink.cocosjs.utils.MsgTools;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.AdError;
import com.anythink.rewardvideo.api.ATRewardVideoAd;
import com.anythink.rewardvideo.api.ATRewardVideoListener;
import java.util.HashMap;
import org.cocos2dx.lib.Cocos2dxJavascriptJavaBridge;
import org.json.JSONObject;

public class RewardVideoHelper
extends BaseHelper {
    private static final String TAG = RewardVideoHelper.class.getSimpleName();
    ATRewardVideoAd mRewardVideoAd;
    String mPlacementId;
    Activity mActivity;
    boolean isReady = false;

    public RewardVideoHelper() {
        MsgTools.pirntMsg(TAG + ": " + this);
        this.mActivity = JSPluginUtil.getActivity();
    }

    @Override
    public void setAdListener(String callbackNameJson) {
        super.setAdListener(callbackNameJson);
    }

    private void initVideo(String placementId) {
        this.mPlacementId = placementId;
        MsgTools.pirntMsg("initVideo placementId: " + this.mPlacementId);
        this.mRewardVideoAd = new ATRewardVideoAd((Context)this.mActivity, placementId);
        this.mRewardVideoAd.setAdListener(new ATRewardVideoListener(){

            public void onRewardedVideoAdLoaded() {
                MsgTools.pirntMsg("onRewardedVideoAdLoaded: " + RewardVideoHelper.this.mPlacementId);
                if (RewardVideoHelper.this.hasCallbackName("RewardedVideoLoaded")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            RewardVideoHelper.this.isReady = true;
                            Cocos2dxJavascriptJavaBridge.evalString((String)(RewardVideoHelper.this.getCallbackName("RewardedVideoLoaded") + "('" + RewardVideoHelper.this.mPlacementId + "');"));
                        }
                    });
                }
            }

            public void onRewardedVideoAdFailed(final AdError pAdError) {
                MsgTools.pirntMsg("onRewardedVideoAdFailed: " + RewardVideoHelper.this.mPlacementId + ", " + pAdError.getFullErrorInfo());
                if (RewardVideoHelper.this.hasCallbackName("RewardedVideoLoadFail")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            RewardVideoHelper.this.isReady = false;
                            Cocos2dxJavascriptJavaBridge.evalString((String)(RewardVideoHelper.this.getCallbackName("RewardedVideoLoadFail") + "('" + RewardVideoHelper.this.mPlacementId + "','" + CommonUtil.getErrorMsg(pAdError) + "');"));
                        }
                    });
                }
            }

            public void onRewardedVideoAdPlayStart(final ATAdInfo adInfo) {
                MsgTools.pirntMsg("onRewardedVideoAdPlayStart: " + RewardVideoHelper.this.mPlacementId);
                if (RewardVideoHelper.this.hasCallbackName("RewardedVideoPlayStart")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(RewardVideoHelper.this.getCallbackName("RewardedVideoPlayStart") + "('" + RewardVideoHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onRewardedVideoAdPlayEnd(final ATAdInfo adInfo) {
                MsgTools.pirntMsg("onRewardedVideoAdPlayEnd: " + RewardVideoHelper.this.mPlacementId);
                if (RewardVideoHelper.this.hasCallbackName("RewardedVideoPlayEnd")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(RewardVideoHelper.this.getCallbackName("RewardedVideoPlayEnd") + "('" + RewardVideoHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onRewardedVideoAdPlayFailed(final AdError adError, final ATAdInfo adInfo) {
                MsgTools.pirntMsg("onRewardedVideoAdPlayFailed: " + RewardVideoHelper.this.mPlacementId + ", " + adError.getFullErrorInfo());
                if (RewardVideoHelper.this.hasCallbackName("RewardedVideoPlayFail")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(RewardVideoHelper.this.getCallbackName("RewardedVideoPlayFail") + "('" + RewardVideoHelper.this.mPlacementId + "','" + CommonUtil.getErrorMsg(adError) + "','" + adInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onRewardedVideoAdClosed(final ATAdInfo adInfo) {
                MsgTools.pirntMsg("onRewardedVideoAdClosed: " + RewardVideoHelper.this.mPlacementId);
                if (RewardVideoHelper.this.hasCallbackName("RewardedVideoClose")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(RewardVideoHelper.this.getCallbackName("RewardedVideoClose") + "('" + RewardVideoHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onRewardedVideoAdPlayClicked(final ATAdInfo adInfo) {
                MsgTools.pirntMsg("onRewardedVideoAdPlayClicked: " + RewardVideoHelper.this.mPlacementId);
                if (RewardVideoHelper.this.hasCallbackName("RewardedVideoClick")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(RewardVideoHelper.this.getCallbackName("RewardedVideoClick") + "('" + RewardVideoHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                        }
                    });
                }
            }

            public void onReward(final ATAdInfo adInfo) {
                MsgTools.pirntMsg("onReward: " + RewardVideoHelper.this.mPlacementId);
                if (RewardVideoHelper.this.hasCallbackName("RewardedVideoReward")) {
                    JSPluginUtil.runOnGLThread(new Runnable(){

                        @Override
                        public void run() {
                            Cocos2dxJavascriptJavaBridge.evalString((String)(RewardVideoHelper.this.getCallbackName("RewardedVideoReward") + "('" + RewardVideoHelper.this.mPlacementId + "','" + adInfo.toString() + "');"));
                        }
                    });
                }
            }
        });
    }

    public void loadRewardedVideo(final String placementId, final String settings) {
        MsgTools.pirntMsg("loadRewardedVideo: " + placementId + ", settings: " + settings);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (RewardVideoHelper.this.mRewardVideoAd == null) {
                    RewardVideoHelper.this.initVideo(placementId);
                }
                if (!TextUtils.isEmpty((CharSequence)settings)) {
                    HashMap<String, String> localExtra = new HashMap<String, String>();
                    String userId = "";
                    String userData = "";
                    try {
                        JSONObject jsonObject = new JSONObject(settings);
                        RewardVideoHelper.fillMapFromJsonObject(localExtra, jsonObject);
                        if (jsonObject.has("userID")) {
                            userId = jsonObject.optString("userID");
                        }
                        if (jsonObject.has("media_ext")) {
                            userData = jsonObject.optString("media_ext");
                        }
                        localExtra.put("user_id", userId);
                        localExtra.put("user_custom_data", userData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    RewardVideoHelper.this.mRewardVideoAd.setLocalExtra(localExtra);
                }
                RewardVideoHelper.this.mRewardVideoAd.load();
            }
        });
    }

    public void showVideo(final String scenario) {
        MsgTools.pirntMsg("showVideo: " + this.mPlacementId + ", scenario: " + scenario);
        JSPluginUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (RewardVideoHelper.this.mRewardVideoAd != null) {
                    RewardVideoHelper.this.isReady = false;
                    RewardVideoHelper.this.mRewardVideoAd.show(RewardVideoHelper.this.mActivity, scenario);
                } else {
                    MsgTools.pirntMsg("showVideo error, you must call loadRewardVideo first " + RewardVideoHelper.this.mPlacementId);
                    if (RewardVideoHelper.this.hasCallbackName("RewardedVideoLoadFail")) {
                        JSPluginUtil.runOnGLThread(new Runnable(){

                            @Override
                            public void run() {
                                Cocos2dxJavascriptJavaBridge.evalString((String)(RewardVideoHelper.this.getCallbackName("RewardedVideoLoadFail") + "('" + RewardVideoHelper.this.mPlacementId + "','you must call loadRewardVideo first');"));
                            }
                        });
                    }
                }
            }
        });
    }

    public boolean isAdReady() {
        MsgTools.pirntMsg("video isAdReady: " + this.mPlacementId);
        try {
            if (this.mRewardVideoAd != null) {
                boolean isAdReady = this.mRewardVideoAd.isAdReady();
                MsgTools.pirntMsg("video isAdReady: " + this.mPlacementId + ", " + isAdReady);
                return isAdReady;
            }
            MsgTools.pirntMsg("video isAdReady error, you must call loadRewardedVideo first " + this.mPlacementId);
            MsgTools.pirntMsg("video isAdReady, end: " + this.mPlacementId);
        }
        catch (Throwable e) {
            MsgTools.pirntMsg("video isAdReady, Throwable: " + e.getMessage());
            return this.isReady;
        }
        return this.isReady;
    }

    public String checkAdStatus() {
        MsgTools.pirntMsg("video checkAdStatus: " + this.mPlacementId);
        if (this.mRewardVideoAd != null) {
            ATAdStatusInfo atAdStatusInfo = this.mRewardVideoAd.checkAdStatus();
            boolean loading = atAdStatusInfo.isLoading();
            boolean ready = atAdStatusInfo.isReady();
            ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("isLoading", loading);
                jsonObject.put("isReady", ready);
                jsonObject.put("adInfo", (Object)atTopAdInfo);
                return jsonObject.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return "";
    }
}

